<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 697px;">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">My account</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?= $title ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="shadow mb-4 border-bottom-success">
                            <div class="card-header py-3 d-flex justify-content-between">
                                <?php echo $__env->make('dashboard.user.partials.balance_and_currency', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <?php echo $__env->make('dashboard.user.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <div class="card-header">
                                        <h4>Deposit funds</h4>
                                        <p>Select one of the options to deposit funds to your account</p>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">

                                            <div class="col-sm-12 col-md-5">
                                                <h4>Deposit via:</h4>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <a href="<?php echo e(route('user.deposit.card')); ?>"><img width="100%"
                                                                src="/dashboard/resources/images/card.jpg"
                                                                alt=""></a>
                                                    </div>
                                                    <div class="col-6">
                                                        <a href="<?php echo e(route('user.deposit.bitcoin')); ?>"><img width="100%"
                                                                src="/dashboard/resources/images/bitcoin.png"
                                                                alt=""></a>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-7 scroll-card-body">
                                                <ul class="list-group">
                                                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <a href="<?php echo e(route('user.deposit.show', $deposit->uuid)); ?>"
                                                            class="list-group-item list-group-item-action <?php echo e($deposit->status != 1 ? 'text-danger' : 'text-success'); ?>">
                                                            <span
                                                                class="badge <?php echo e($deposit->status != 1 ? 'bg-danger' : 'bg-success'); ?> text-white float-right"><?php echo e($deposit->status != 1 ? 'PENDING' : 'CONFIRMED'); ?></span>
                                                            <h5 class="m-0 p-0">
                                                                <span
                                                                    class="<?php echo e($deposit->status != 1 ? 'text-danger' : 'text-success'); ?> ">
                                                                    <?php echo e(currency($user->currency) . formatAmount($deposit->amount)); ?>

                                                                    <small><?php echo e(currency($user->currency, 'name')); ?></small>
                                                            </h5>
                                                            <p class="m-0 p-0">
                                                                Payment with <?php echo e($deposit->method); ?> <br>
                                                                Transaction ID: <?php echo e($deposit->reference_id); ?> </p>
                                                            <small class="float-right">
                                                                Date: <?php echo e(date('dS M,Y', strtotime($deposit->date))); ?>

                                                            </small>
                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <h5>Deposit history</h5>
                                                        <div class="alert alert-warning" role="alert">
                                                            No deposit record found
                                                        </div>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="card-footer" style="overflow: hidden;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\user\deposit\index.blade.php ENDPATH**/ ?>