<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <link rel="icon" href="<?php echo e(asset('dashboard/resources/images/logo.png')); ?>">


        <title><?php echo e($title); ?></title>

        <!-- Vendors Style-->
        <link rel="stylesheet" href="/dashboard/resources/css/vendors_css.css">
        <!-- Style-->
        <link rel="stylesheet" href="/dashboard/resources/css/style.css">
        <link rel="stylesheet" href="/dashboard/resources/css/skin_color.css">
        <style>
            iframe {
                display: none;
            }
        </style>
        <style>
            img[alt*="000webhost"],
            img[alt*="000webhost"][style],
            img[src*="000webhost"],
            img[src*="000webhost"][style],
            body>div:nth-last-of-type(1)[style] {
                opacity: 0 !important;
                pointer-events: none !important;
                width: 0px !important;
                height: 0px !important;
                visibility: hidden !important;
                display: none !important;
            }
        </style>
    </head>

    <body class="hold-transition theme-primary bg-img  text-primary"
        style="background-image: url(/theme/bitcoin/images/backgrounds/call-to-action-bg.jpg); background-size:contain">
        <div class="container">
            <div class="row">

                <div class="col-12 pt-5">
                    <div class="row justify-content-center g-0">
                        <div class="col-lg-12 col-md-12 col-12">
                            <div class="bg-white rounded10 shadow-lg">
                                <div class="p-40">
                                    <div class="col-sm-12 col-md-8 offset-md-2 pt-5">
                                        <div class="d-flex justify-content-between">
                                            <a href="/"><img width="300"
                                                    src="<?php echo e(asset('dashboard/resources/images/logo.png')); ?>"
                                                    alt="<?php echo e(config('app.name')); ?>"></a>
                                        </div>
                                        <div class="text-left">
                                            <h1 class="h4 mb-2"><?php echo e($title); ?></h1>
                                            <p>Choose the best account for you and enjoy Online Banking, Mobile Banking,
                                                a debit card with Total Security Protection® - and much more. Apply
                                                today in minutes and get a bank account that works for you.</p>
                                        </div>
                                        <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <form class="row" method="POST" action="<?php echo e(route('register')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="">First name</label>
                                                    <input type="text" name="first_name"
                                                        value="<?= old('first_name') ?>"
                                                        class="form-control bg-light border-1 small" id=""
                                                        placeholder="First Name">
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="">Last name</label>
                                                    <input type="text" name="last_name"
                                                        value="<?= old('last_name') ?>"
                                                        class="form-control bg-light border-1 small" id=""
                                                        placeholder="Last Name">
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="">Email address</label>
                                                    <input type="email" name="email" value="<?= old('email') ?>"
                                                        class="form-control bg-light border-1 small"
                                                        id="exampleInputEmail" placeholder="Email Address">
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6 ">
                                                <div class="form-group">
                                                    <label for="">Registration token</label>
                                                    <input type="text" name="registration_token"
                                                        value="<?= old('registration_token') ?>"
                                                        class="form-control bg-light border-1 small" id=""
                                                        placeholder="Registration token">
                                                    <input type="hidden" name="referred" value="0">
                                                </div>
                                            </div>

                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <div class="form-group">
                                                    <label for="">Date of Birth</label>
                                                    <input value="<?= old('dob') ?>" type="date" name="dob"
                                                        class="form-control bg-light border-1 small" id="">
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <div class="form-group">
                                                    <label for="">Gender</label>
                                                    <select class="form-control bg-light border-1 small" name="gender"
                                                        id="">
                                                        <option value="">Select</option>
                                                        <option value="male"
                                                            <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>>Male
                                                        </option>
                                                        <option value="female"
                                                            <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>>Female
                                                        </option>
                                                        <option value="other"
                                                            <?php echo e(old('gender') == 'other' ? 'selected' : ''); ?>>Other
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <div class="form-group">
                                                    <label for="">Marital Status</label>
                                                    <select name="marital_status" id=""
                                                        class="form-control bg-light border-1 small">
                                                        <option value="">Select</option>
                                                        <option value="single"
                                                            <?php echo e(old('marital_status') == 'single' ? 'selected' : ''); ?>>
                                                            Single</option>
                                                        <option value="married"
                                                            <?php echo e(old('marital_status') == 'married' ? 'selected' : ''); ?>>
                                                            Married</option>
                                                        <option value="separated"
                                                            <?php echo e(old('marital_status') == 'separated' ? 'selected' : ''); ?>>
                                                            Separated</option>
                                                        <option value="divorced"
                                                            <?php echo e(old('marital_status') == 'divorced' ? 'selected' : ''); ?>>
                                                            Divorced</option>
                                                        <option value="widowed"
                                                            <?php echo e(old('marital_status') == 'widowed' ? 'selected' : ''); ?>>
                                                            Widowed</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Dial code</label>
                                                <select name="dial_code" id=""
                                                    class="form-control bg-light border-1 small">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = config('setting.dial_code'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dialCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="+<?php echo e($key); ?>"
                                                            <?php echo e(old('dial_code') == '+' . $key ? 'selected' : ''); ?>>
                                                            <?php echo e($dialCode); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Phone</label>
                                                <input type="number" name="phone"
                                                    class="form-control bg-light border-1 small"
                                                    value="<?= old('phone') ?>" placeholder="Phone">
                                            </div>

                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Professional Status</label>
                                                <input type="text" placeholder="e.g Employed, Student, Engineer"
                                                    value="<?= old('professional_status') ?>"
                                                    name="professional_status"
                                                    class="form-control bg-light border-1 small">
                                            </div>
                                            <div class="mb-2 col-12">
                                                <label for="">Address</label>
                                                <input type="text" placeholder="Your contact address"
                                                    name="address" value="<?= old('address') ?>"
                                                    class="form-control bg-light border-1 small">
                                            </div>
                                            <div class="mb-2 col-sm-6">
                                                <label for="">State</label>
                                                <input type="text" placeholder="Your state" name="state"
                                                    value="<?= old('state') ?>"
                                                    class="form-control bg-light border-1 small">
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Nationality</label>
                                                <select name="nationality" id=""
                                                    class="form-control bg-light border-1 small">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = config('setting.nationality'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $nationality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($nationality); ?>"
                                                            <?php echo e(old('nationality') == $nationality ? 'selected' : ''); ?>>
                                                            <?php echo e($nationality); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Currency</label>
                                                <select name="currency" id=""
                                                    class="form-control bg-light border-1 small">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = config('setting.currency'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($currency['name']); ?>-<?php echo e($currency['code']); ?>-<?php echo e($currency['symbol']); ?>"
                                                            <?php echo e(old('currency') == $currency['name'] . '-' . $currency['code'] . '-' . $currency['symbol'] ? 'selected' : ''); ?>>
                                                            <?php echo e($currency['name']); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-md-4">
                                                <label for="">Account Type</label>
                                                <select name="account_type" id=""
                                                    class="form-control bg-light border-1 small">
                                                    <option value="savings" <?php echo e(old('account_type') == 'savings'); ?>>
                                                        Savings account</option>
                                                    <option value="current" <?php echo e(old('account_type') == 'current'); ?>>
                                                        Current Account</option>
                                                    <option value="corporate"
                                                        <?php echo e(old('account_type') == 'corporate'); ?>>Corporate account
                                                    </option>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" required name="password" value=""
                                                        class="form-control bg-light border-1 small" id="password"
                                                        placeholder="Password" required autocomplete="new-password">
                                                    <?php if($errors->has('password')): ?>
                                                        <p class="text-danger"><?php echo e($errors->first('password')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="password_confirmation">Confirm Password</label>
                                                    <input type="password" required name="password_confirmation"
                                                        class="form-control bg-light border-1 small" id=""
                                                        placeholder="Repeat Password">
                                                    <?php if($errors->has('password_confirmation')): ?>
                                                        <p class="text-danger"><?php echo e($errors->first('password_confirmation')); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary btn-user btn-block">
                                                    Create account
                                                </button>

                                            </div>
                                        </form>
                                    </div>
                                    <div class="text-center">
                                        <p class="mt-15 mb-0">Already have an account? <a href="<?php echo e(route('login')); ?>"
                                                class="text-warning ms-5">Login account</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vendor JS -->
        <script src="/dashboard/resources/js/vendors.min.js"></script>
        <script src="/dashboard/resources/js/pages/chat-popup.js"></script>
        <script src="/dashboard/resources/assets/icons/feather-icons/feather.min.js"></script>

        <script src="/dashboard/resources/js/themes/animated.js"></script>
        <script src="/dashboard/resources/assets/vendor_components/Web-Ticker-master/jquery.webticker.min.js"></script>
        <script src="/dashboard/resources/assets/vendor_components/moment/min/moment.min.js"></script>
        <script src="/dashboard/resources/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>

        <!-- Specie Admin Admin App -->
        <script src="/dashboard/resources/js/demo.js"></script>
        <script src="/dashboard/resources/js/template.js"></script>
        <script src="/dashboard/resources/js/pages/dashboard.js"></script>
        <?php echo $__env->make('partials.live_chat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script>
            var myModal = new bootstrap.Modal(document.getElementById('modal-center'), {
                keyboard: false
            })
            myModal.show();
        </script>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\auth\register.blade.php ENDPATH**/ ?>