<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 300px;
                margin-bottom: 10px;
            }

            .header h1 {
                margin: 0;
                font-size: 24px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 20px;
            }

            .content th,
            .content td {
                text-align: left;
                padding: 12px;
                border: 1px solid #dddddd;
            }

            .content th {
                /* background-color: #f2d7d5; */
                color: #333333;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="<?php echo e(asset('dashboard/resources/images/logo.png')); ?>" alt="Logo">
            </div>
            <div class="content">
                <p>Dear <?php echo e($user->first_name . ' ' . $user->last_name); ?>,</p>
                <p>We are pleased to inform you that your
                    <?php echo e($transaction->type == 'CREDIT' ? 'credit' : 'debit'); ?>

                    transaction has been successfully completed. Below are
                    the details of your transaction:</p>
                <h3 style="text-align: center">Transaction Details</h3>

                <table>
                    <?php if($transfer->type == 'Direct Bank Transfer'): ?>
                        <tr>
                            <th>Beneficiary Bank</th>
                            <td><?php echo e($transfer->bank_name); ?></td>
                        </tr>
                        <tr>
                            <th>Beneficiary Name</th>
                            <td><?php echo e($transfer->account_name); ?></td>
                        </tr>
                        <tr>
                            <th>Beneficiary Account</th>
                            <td><?php echo e($transfer->account_number); ?></td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <th>Beneficiary</th>
                            <td><?php echo e($transfer->beneficiary); ?></td>
                        </tr>
                        <tr>
                            <th>Withdrawal Method</th>
                            <td><?php echo e($transfer->withdrawal_method); ?></td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <th>Description</th>
                        <td><?php echo e($transaction->description); ?></td>
                    </tr>
                    <tr>
                        <th>Transaction ID</th>
                        <td><?php echo e($transaction->reference_id); ?></td>
                    </tr>
                    <tr>
                        <th>Transaction Type</th>
                        <td><?php echo e($transaction->type == 'CREDIT' ? 'Credit' : 'Debit'); ?></td>
                    </tr>
                    <tr>
                        <th>Amount</th>
                        <td><?php echo e(currency($user->currency) . formatAmount($transaction->amount)); ?></td>
                    </tr>
                    <tr>
                        <th>Date</th>
                        <td><?php echo e(date('dS M Y', strtotime($transaction->date))); ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td><?php echo e($transaction->status == 1 ? 'Successful' : 'Failed'); ?></td>
                    </tr>
                </table>
                <p>Following this transaction, the balances on your account are as follows:</p>
                <table>
                    <tr>
                        <th>Available Balance</th>
                        <td><?php echo e(currency($user->currency) . formatAmount($transaction->current_balance)); ?></td>
                    </tr>
                    
                </table>

                <p>If you have any questions or need further assistance, please do not hesitate to contact our support
                    team.</p>
                <p>Thank for banking with us!</p>

            </div>
            <div class="footer">
                <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\mail\transfer.blade.php ENDPATH**/ ?>