<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 697px;">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">My account</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?= $title ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Main content -->
            <section class="content">
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="mb-4 border-bottom-success">
                            <div class="card-header py-3 d-flex justify-content-between">
                                <?php echo $__env->make('dashboard.user.partials.balance_and_currency', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <?php echo $__env->make('dashboard.user.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-7">
                                    <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <div class="box-body">
                                        <form action="<?php echo e(route('user.card.store')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                <label for="name">Name</label>
                                                <input type="text" class="form-control" id="name" name="name"
                                                    value="<?php echo e(old('name', $user->first_name . ' ' . $user->last_name)); ?>"
                                                    readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="type">Type of Card</label>
                                                <select class="form-control" id="type" name="type" required>
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $cardTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cardType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($cardType->value); ?>"><?php echo e($cardType->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="residential_address">Residential Address</label>
                                                <input type="text" class="form-control" id="residential_address"
                                                    name="residential_address"
                                                    value="<?php echo e(old('residential_address', $user->address)); ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="registration_token">Registration Token</label>
                                                <input type="text" class="form-control" id="registration_token"
                                                    name="registration_token"
                                                    value="<?php echo e(old('registration_token', $user->registration_token)); ?>"
                                                    readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="phone">Phone Number</label>
                                                <input type="text" class="form-control" id="phone" name="phone"
                                                    value="<?php echo e(old('phone', $user->phone)); ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="email">Email</label>
                                                <input type="email" class="form-control" id="email" name="email"
                                                    value="<?php echo e(old('email', $user->email)); ?>" required>
                                            </div>
                                            <button type="submit" class="btn btn-primary mt-4">Submit Request</button>
                                        </form>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-5 mt-5">
                                    <div class="card mt-5">
                                        <div class="card-header">Card Request Details</div>
                                        <div class="card-body">
                                            <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <p>Submitted Application Date: <?php echo e($card->date); ?></p>
                                                <p>Application Status: <?php echo e($card->status == 0 ? 'Pending' : 'Approved'); ?>

                                                </p>
                                                <p>Card Type:

                                                    <?php $__currentLoopData = $cardTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cardType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($card->type == $cardType->value): ?>
                                                            <?php echo e($cardType->name); ?>

                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </p>
                                                <hr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <p>No card request found.</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\user\card\index.blade.php ENDPATH**/ ?>