<?php $__env->startSection('content'); ?>
    <style>
        .statement-table th,
        .statement-table td {
            text-align: left;
        }

        .statement-table thead th {
            background-color: #d3d3d3;
        }

        .statement-table tfoot {
            font-weight: bold;
            background-color: #d3d3d3;
        }
    </style>
    <div class="content-wrapper" style="min-height: 697px;">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">My account</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?= $title ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="card shadow mb-4 border-bottom-success">
                            <div class="card-header py-3 d-flex justify-content-between">
                                <?php echo $__env->make('dashboard.user.partials.balance_and_currency', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo $__env->make('dashboard.user.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <div class="card-header">
                                        <a href="<?php echo e(route('user.account.statement.download', [$fromDate, $toDate])); ?>"
                                            class="btn btn-success btn-sm">Download PDF</a>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-8 table-responsive">
                                                <table id="statementTable"
                                                    class="table table-bordered table-striped statement-table">
                                                    <thead class="thead-dark">
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Description</th>
                                                            <th>Reference ID</th>
                                                            <th>Amount</th>
                                                            <th>Type</th>
                                                            <th>Balance</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($transaction->date); ?></td>
                                                                <td><?php echo e($transaction->description); ?></td>
                                                                <td><?php echo e($transaction->reference_id); ?></td>
                                                                <td><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->amount)); ?>

                                                                </td>
                                                                <td><?php echo e($transaction->type); ?></td>
                                                                <td><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->current_balance)); ?>

                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </tbody>
                                                    <tfoot class="thead-dark">
                                                        <tr>
                                                            <td colspan="3"><strong>*** Totals ***</strong></td>
                                                            <td><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($totalAmount)); ?>

                                                            </td>
                                                            <td></td>
                                                            <td></td>
                                                        </tr>
                                                    </tfoot>
                                                </table>
                                                <div class="mt-5 d-flex justify-content-center">
                                                    <?php if($transactions->hasPages()): ?>
                                                        <?php echo e($transactions->withQueryString()->links()); ?>

                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-sm-12 col-md-4">
                                                <?php echo $__env->make('dashboard.user.partials.personal_account_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\user\account_statement\show.blade.php ENDPATH**/ ?>