<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Transaction Receipt</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f9f9f9;
                margin: 0;
                padding: 0;
            }

            .receipt-container {
                width: 600px;
                margin: 50px auto;
                padding: 20px;
                background-color: #fff;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                border-radius: 10px;
            }

            .header {
                text-align: center;
                border-bottom: 1px solid #eee;
                padding-bottom: 20px;
                margin-bottom: 20px;
            }

            .header img {
                height: 40px;
            }

            .header h1 {
                margin: 10px 0;
                font-size: 24px;
                color: #333;
            }

            .amount {
                font-size: 28px;
                color: #00b300;
                margin: 10px 0;
            }

            .status {
                font-size: 18px;
                color: #333;
            }

            .date {
                font-size: 14px;
                color: #777;
            }

            .content {
                font-size: 14px;
                color: #333;
            }

            .content p {
                margin: 10px 0;
            }

            .content p span {
                font-weight: bold;
            }

            .footer {
                text-align: center;
                font-size: 12px;
                color: #777;
                border-top: 1px solid #eee;
                padding-top: 20px;
                margin-top: 20px;
            }

            .footer a {
                color: #00b300;
                text-decoration: none;
            }
        </style>
    </head>

    <body>
        <div class="receipt-container">
            <div class="header">
                <img src="<?php echo e(public_path('/dashboard/resources/images/logo.png')); ?>" alt="logo">
                <h1>Transaction Receipt</h1>
                <div class="amount" <?php echo e($transaction->type == 'DEBIT' ? 'style=color:red' : ''); ?>><?php echo e(currency($user->currency,'code')); ?><?php echo e(formatAmount($transaction->amount)); ?></div>
                <div class="status"><?php echo e($transaction->status == 1 ? 'SUCCESS' : 'FAILED'); ?></div>
                <div class="date"><?php echo e(date('M d, Y', strtotime($transaction->date))); ?>,
                    <?php echo e(date('H:i:s', strtotime($transaction->time))); ?></div>
            </div>
            <div class="content">
                <p><span>Transaction Type:</span> <?php echo e($transaction->type); ?></p>
                <?php if(!empty($transfer)): ?>
                    <?php if($transfer->type == 'Electronic Transfer'): ?>
                        <p><span>Beneficiary:</span><?php echo e($transfer->beneficiary); ?><br><?php echo e($transfer->withdrawal_method); ?>

                        </p>
                        <p><span>Sender Details:</span>
                            <?php echo e($user->first_name . ' ' . $user->last_name); ?><br><?php echo e(config('app.name')); ?> |
                            <?php echo e(getMaskedAccountNumber($user->account_number)); ?></p>
                    <?php else: ?>
                        <p><span>Recipient Details:</span><?php echo e($transfer->account_name); ?><br><?php echo e($transfer->bank_name); ?>

                            |
                            <?php echo e($transfer->account_number); ?></p>
                        <p><span>Sender Details:</span>
                            <?php echo e($user->first_name . ' ' . $user->last_name); ?><br><?php echo e(config('app.name')); ?> |
                            <?php echo e(getMaskedAccountNumber($user->account_number)); ?></p>
                    <?php endif; ?>
                <?php else: ?>
                    <p><span>Recipient
                            Details:</span><?php echo e($user->first_name . ' ' . $user->last_name); ?><br><?php echo e(config('app.name')); ?>

                        |
                        <?php echo e($user->account_number); ?></p>
                <?php endif; ?>
                <p><span>Remark:</span> <?php echo e($transaction->description); ?></p>
                <p><span>Transaction Reference:</span> <?php echo e($transaction->reference_id); ?></p>
                <p><span>SessionID:</span> <?php echo e($transaction->uuid); ?></p>
            </div>
            <div class="footer">
                <p>Support: <a href="mailto:<?php echo e(config('app.email')); ?>"><?php echo e(config('app.email')); ?></a></p>
                <p>Enjoy a reliable & stable network service on <?php echo e(config('app.name')); ?>.</p>
            </div>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\pdf\transaction_2.blade.php ENDPATH**/ ?>